<?php

class PeselValidator extends CValidator
{
	public $disableChecksum = false;

	/**
	 * @param CModel $object
	 * @param string $attribute
	 */
	protected function validateAttribute($object, $attribute)
	{
		$value = trim($object->$attribute);

		if (empty($value)) return;

		static $weights = array(1, 3, 7, 9, 1, 3, 7, 9, 1, 3, 1);

		if (!preg_match('/^[0-9]{' . (count($weights)) . '}$/', $value))
		{
			$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute jest nieprawidłowe.'), array(
				'attribute' => $object->getAttributeLabel($attribute)
			));
			return;
		}

		if ($this->disableChecksum)
			return;

		$sum = 0;
		$values = str_split($value);
		foreach ($weights as $i => $val)
			$sum += (int)$values[$i] * (int)$val;
		$sum %= 10;

		if ($sum !== 0)
			$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute ma niepoprawną sumę kontrolną.'), array(
				'attribute' => $object->getAttributeLabel($attribute)
			));
	}
}
